      SUBROUTINE EVCARD
C***********************************************************************
C                 EVCARD Module of ISCEV2 Model
C
C        PURPOSE: To process EVent Pathway card images
C
C        PROGRAMMER:  Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To incorporate modifications to date processing
C                    for Y2K compliance, including use of date window
C                    variables (ISTRT_WIND and ISTRT_CENT) and calculation
C                    of 10-digit variables for start date (ISDATE) and
C                    end date (IEDATE).
C                    R.W. Brode, PES, Inc., 5/12/99
C
C        MODIFIED:   To remove reassignment of ISYEAR.
C                    R.W. Brode, PES, 4/2/99
C
C        MODIFIED:   To remove mixed-mode math in calculation of
C                    ISDATE and IEDATE - 4/19/93
C
C        INPUTS:  Pathway (EV) and Keyword
C
C        OUTPUTS: Pass Two Event Setup
C
C        CALLED FROM:   SETUP
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, ILSAVE, ITEMPDATE, ITEMPYEAR

C     Variable Initializations
      MODNAM = 'EVCARD'

      IF (KEYWRD .EQ. 'STARTING') THEN
C        Set Status Switch
         IESTAT(1) = IESTAT(1)+1
         IEVENT = 1
         IF (IESTAT(1) .NE. 1) THEN
C           Error Message: Repeat Starting In Same Pathway
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         END IF
      ELSE IF (KEYWRD .EQ. 'EVENTPER') THEN
C        Set Status Switch
         IESTAT(2) = IESTAT(2)+1
C        Check for First Occurrence of EVENTPER Card, and
C        Reinitialize IPROC Array
         IF (IESTAT(2) .EQ. 1) THEN
            DO I = 1, 366
               IPROC(I) = 0
            END DO
         END IF
C        Process Average Period, Date and Source Group      ---   CALL EVPER
         CALL EVPER
      ELSE IF (KEYWRD .EQ. 'EVENTLOC') THEN
C        Set Status Switch
         IESTAT(3) = IESTAT(3)+1
C        Process Discrete Receptor Location                 ---   CALL EVLOC
         CALL EVLOC
      ELSE IF (KEYWRD .EQ. 'INCLUDED') THEN
C        Set Status Switch
         IESTAT(10) = IESTAT(10) + 1
C        Save ILINE as ISAVE
         ILSAVE = ILINE
C        Process the Included Receptor File                 ---   CALL INCLUD
         CALL INCLUD
C        Retrieve ILINE From ISAVE         
         ILINE = ILSAVE
      ELSE IF (KEYWRD .EQ. 'FINISHED') THEN
C        Check for missing EVENTLOC cards
         IF (IESTAT(2) .GT. IESTAT(3)) THEN
C           Write Error Message:  Missing EVENTLOC
            CALL ERRHDL(PATH,MODNAM,'E','130','EVENTLOC')
         END IF
         NUMEVE = IEVENT - 1
C        Set Status Switch
         IESTAT(25) = IESTAT(25)+1
         IF (IESTAT(25) .NE. 1) THEN
C           Error Message: Repeat Finished In Same Pathway
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
            GO TO 999
         END IF

C        Get start date, ISDATE, and end date, IEDATE
         ISDATE = EVDATE(1)
         IEDATE = EVDATE(1)
         ISYR = ISDATE/1000000
         IEYR = IEDATE/1000000
C        Convert 8-digit EVDATE to 10-digit ISDATE and IEDATE
         IF (ISYR .GE. ISTRT_WIND .AND. ISYR .LE. 99) THEN
            ISYR   = ISTRT_CENT*100 + ISYR
            ISDATE = ISTRT_CENT*100000000 + ISDATE
         ELSE IF (ISYR .LT. ISTRT_WIND) THEN
            ISYR   = (ISTRT_CENT+1)*100 + ISYR
            ISDATE = (ISTRT_CENT+1)*100000000 + ISDATE
         END IF
         IF (IEYR .GE. ISTRT_WIND .AND. IEYR .LE. 99) THEN
            IEYR   = ISTRT_CENT*100 + IEYR
            IEDATE = ISTRT_CENT*100000000 + IEDATE
         ELSE IF (IEYR .LT. ISTRT_WIND) THEN
            IEYR   = (ISTRT_CENT+1)*100 + IEYR
            IEDATE = (ISTRT_CENT+1)*100000000 + IEDATE
         END IF
C        Loop through events to find start date and end date
         DO I = 1, NUMEVE
            ITEMPDATE = EVDATE(I)
            ITEMPYEAR = ITEMPDATE/1000000
            IF (ITEMPYEAR .GE. ISTRT_WIND .AND. ITEMPYEAR .LE. 99) THEN
               ITEMPDATE = ISTRT_CENT*100000000 + ITEMPDATE
            ELSE IF (ITEMPYEAR .LT. ISTRT_WIND) THEN
               ITEMPDATE = (ISTRT_CENT+1)*100000000 + ITEMPDATE
            END IF
            IF (ITEMPDATE .LT. ISDATE) ISDATE = ITEMPDATE
            IF (ITEMPDATE .GT. IEDATE) IEDATE = ITEMPDATE
         END DO
C        Set start hour to 00 and end hour to 24
         ISDATE = (ISDATE/100)*100
         IEDATE = (IEDATE/100)*100 + 24
         ISYR = ISDATE/1000000
         IEYR = IEDATE/1000000
         ISMN = (ISDATE/10000) - (ISDATE/1000000)*100
         IEMN = (IEDATE/10000) - (IEDATE/1000000)*100
         ISDY = (ISDATE/100) - (ISDATE/10000)*100
         IEDY = (IEDATE/100) - (IEDATE/10000)*100

C        Write Out The Error Message: Mandatory Keyword Missing
         IF (IESTAT(1) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','STARTING')
         END IF
         IF (IESTAT(2) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','EVENTPER')
         END IF
         IF (IESTAT(3) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','EVENTLOC')
         END IF

      ELSE
C        Write Error Message: Invalid Keyword for This Pathway
         CALL ERRHDL(PATH,MODNAM,'E','110',KEYWRD)
      END IF

 999  RETURN
      END

      SUBROUTINE EVPER
C***********************************************************************
C                 EVPER Module of ISCEV2 Model
C
C        PURPOSE: Processes Date, Average Period And Source Group data
C                 for EVENT
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To incorporate modifications to date processing
C                    for Y2K compliance, including use of date window
C                    variables (ISTRT_WIND and ISTRT_CENT).
C                    R.W. Brode, PES, Inc., 5/12/99
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Event Name, Group ID, Average Period, Date
C
C        CALLED FROM:   EVCARD
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: ISDX, IMN, IDY, IEVYR2, IEVYR4
      CHARACTER USEVN*8
      LOGICAL FIND
      DOUBLE PRECISION DNUM

C     Variable Initializations
      MODNAM = 'EVPER'
      FIND = .FALSE.

      IF (IEVENT .GT. NEVE) THEN
C        WRITE Error Message    ! Too Many Events Specified
         WRITE(DUMMY,'(I8)') NEVE
         CALL ERRHDL(PATH,MODNAM,'E','290',DUMMY)
         GO TO 999
      END IF

C     Check Whether There Are Enough Parameter Fields
      IF (IFC .EQ. 2) THEN
C        Error Message: Missing Parameter
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GO TO 999
      ELSE IF (IFC .LT. 6) THEN
C        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GO TO 999
      ELSE IF (IFC .GT. 7) THEN
C        Error Message: Too Many Parameters
C        Note That FIELD(7) Is Ignored If Present:  Used To Hold
C        Concentration Value for Events Generated From PASS ONE
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GO TO 999
      END IF

C     READ EVNAME, AVEPER, GRPID, DATE

C     Get The Event Name
      USEVN = FIELD(3)
C     Check for Previous EVNAME
      CALL SINDEX(EVNAME,NEVE,USEVN,ISDX,FIND)
      IF (.NOT.FIND) THEN
         EVNAME(IEVENT) = USEVN
      ELSE
C        Error Message: Duplicate EVNAME
         CALL ERRHDL(PATH,MODNAM,'E','313',EVNAME(ISDX))
         GO TO 999
      END IF

C     Get Averaging Period For The Event
      CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
C     Check The Numerical Field
      IF (IMIT .EQ. -1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GO TO 999
      ELSE
         EVAPER(IEVENT) = NINT(FNUM)
      END IF

C     Check for Valid Averaging Period
      DO 100 IAVE = 1, NUMAVE
         IF (EVAPER(IEVENT) .EQ. KAVE(IAVE)) THEN
            FIND = .TRUE.
            IF (EVAPER(IEVENT) .GT. 24) THEN
C              Write Error Message for Invalid Averaging Period, Must be <=24
               CALL ERRHDL(PATH,MODNAM,'E','390',EVNAME(IEVENT))
            END IF
         END IF
 100  CONTINUE
      IF (.NOT. FIND) THEN
C        Error Message: Averaging Period Does Not Match
         CALL ERRHDL(PATH,MODNAM,'E','203','AVEPER')
      END IF

C     Take The Group ID
      EVGRP(IEVENT) = FIELD(5)

C     Retrieve The Index of The Group Array
      FIND = .FALSE.
      CALL SINDEX(GRPID,NGRP,EVGRP(IEVENT),ISDX,FIND)
      IF (.NOT. FIND) THEN
C        Error Message: Group ID Does Not Match
         CALL ERRHDL(PATH,MODNAM,'E','203','GROUPID')
      ELSE
         IDXEV(IEVENT) = ISDX
      END IF

C     Get The Date Of The Event -
C     First Convert Character String to Double Precision Real
      CALL STODBL(FIELD(6),ILEN_FLD,DNUM,IMIT)
C     Check The Numerical Field
      IF (IMIT .EQ. -1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GO TO 999
      ELSE
C        Note - EVDATE is an Integer Array
         EVDATE(IEVENT) = NINT(DNUM)
C        Extract 2-digit year from event date
         IEVYR2 = NINT(DNUM/1000000.)
C        Convert to 4-digit year
         IF (IEVYR2 .GE. ISTRT_WIND .AND. IEVYR2 .LE. 99) THEN
            IEVYR4 = ISTRT_CENT*100 + IEVYR2
         ELSE IF (IEVYR2 .LT. ISTRT_WIND) THEN
            IEVYR4 = (ISTRT_CENT+1)*100 + IEVYR2
         END IF
         IMN = NINT(DNUM/10000.) - NINT(DNUM/1000000.)*100
         IDY = NINT(DNUM/100.) - NINT(DNUM/10000.)*100
         CALL JULIAN(IEVYR4,IMN,IDY,JDAY)
         IF (JDAY .GE. 1 .AND. JDAY .LE. 366) THEN
            IPROC(JDAY) = 1
            EVJDAY(IEVENT) = JDAY
         ELSE
C           WRITE Error Message    ! Invalid Julian Day
            CALL ERRHDL(PATH,MODNAM,'E','203','Juli Day')
            GO TO 999
         END IF
      END IF

      IEVENT = IEVENT + 1

 999  RETURN
      END

      SUBROUTINE EVLOC
C***********************************************************************
C                 EVLOC Module of ISCEV2 Model
C
C        PURPOSE: Processes Receptor Location Inputs for Events
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Event Name, AXR, AYR, AZELEV, AZFLAG of the Event
C
C        CALLED FROM:   EVCARD
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: ISDX
      REAL    :: SETAXR, SETAYR
      CHARACTER USEVN*8, IDNAM1*4, IDNAM2*4
      LOGICAL FIND

C     Variable Initializations
      MODNAM = 'EVLOC'

C     Check Whether There Are Enough Parameter Fields
      IF (IFC .EQ. 2) THEN
C        Error Message: Missing Parameter
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GO TO 999
      ELSE IF (IFC .LT. 7) THEN
C        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GO TO 999
      ELSE IF (IFC .GT. 9) THEN
C        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GO TO 999
      END IF

C     READ Event Name, XCOOR,YCOOR,ELEV,FLAG And Assign to Different Array
      USEVN = FIELD(3)
C     Check for Previous EVNAME
      CALL SINDEX(EVNAME,NEVE,USEVN,ISDX,FIND)
      IF (.NOT.FIND) THEN
C        Error Message: EVNAME Does Not Match
         CALL ERRHDL(PATH,MODNAM,'E','203','EVNAME')
         GO TO 999
      END IF

      IDNAM1 = FIELD(4)

      CALL STONUM(FIELD(5),ILEN_FLD,FNUM,IMIT)
C     Check The Numerical Field
      IF (IMIT .EQ. -1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ELSE
         SETAXR = FNUM
      END IF

      IDNAM2 = FIELD(6)

      CALL STONUM(FIELD(7),ILEN_FLD,FNUM,IMIT)
C     Check The Numerical Field
      IF (IMIT .EQ. -1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ELSE
         SETAYR = FNUM
      END IF

      IF (IFC .GE. 8) THEN
         CALL STONUM(FIELD(8),ILEN_FLD,FNUM,IMIT)
C        Check The Numerical Field
         IF (IMIT .EQ. -1) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ELSE
            AZELEV(ISDX) = FNUM
         END IF
      ELSE
         AZELEV(ISDX) = 0.
      END IF

      IF (IFC .EQ. 9) THEN
         CALL STONUM(FIELD(9),ILEN_FLD,FNUM,IMIT)
C        Check The Numerical Field
         IF (IMIT .EQ. -1) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ELSE
            AZFLAG(ISDX) = FNUM
         END IF
      ELSE
         AZFLAG(ISDX) = 0.
      END IF

      IF (IDNAM1.EQ.'XR=' .AND. IDNAM2.EQ.'YR=') THEN
         AXR(ISDX) = SETAXR
         AYR(ISDX) = SETAYR
      ELSE IF (IDNAM1.EQ.'RNG=' .AND. IDNAM2.EQ.'DIR=') THEN
         AXR(ISDX) = SETAXR*SIN(SETAYR*DTORAD)
         AYR(ISDX) = SETAXR*COS(SETAYR*DTORAD)
      ELSE
C        Write Error Message: Illegal Parameter
         CALL ERRHDL(PATH,MODNAM,'E','203','REC-TYPE')
      END IF

 999  RETURN
      END
