      MODULE MAIN1
C***********************************************************************
C     MAIN1
C     ISCST2 Model Data - Array Names, Array Limits, Named Common Blocks
C                         Global Data for All Modules
C
C     MODIFIED - 12/15/93  For New Settling Routines, and Gridded Terrain
C     MODIFIED - 11/8/93   For Wet Deposition Routines
C     MODIFIED - 7/7/93    For Area Sources
C     MODIFIED - 2/15/93   For Revised Deposition Routines
C     MODIFIED - 7/19/94   For OPENPIT Algorithms (JAH/PES)
C     MODIFIED - 7/27/94   Removed ZDM, displacement height, from METVAR
C     MODIFIED - 7/27/94   Added Variable for 10m Reference Wind Speed
C     MODIFIED - 4/17/95   Output CONC/DEPOS/DDEP/WDEP in same model run
C***********************************************************************

      IMPLICIT NONE

C***********************************************************************
C     User Specified Model Parameters for Array Dimensions
C***********************************************************************

CLF90 Most array limits for data storage are now allocated at runtime.
      INTEGER, PARAMETER :: NSEC= 36, NWSCAT= 6, NKST= 6, NHR= 24,
     &                      NPAIR= 100, NWET=2, NHIANN= 10,
     &                      NMXPM= 10

C**   NSRC   = Max Number of Sources
C**   NREC   = Max Number of Receptors
C**   NGRP   = Max Number of Source Groups
C**   NAVE   = Max Number of Short Term Averaging Periods
C**   NVAL   = Max Number of High Values by Receptor (RECTABLE Keyword)
C**   NTYP   = Max Number of Output Types per Run (CONC, DEPOS, DDEP and WDEP)
C**   NMAX   = Max Number of Overall Maximum Values (MAXTABLE Keyword)
C**   NSEC   = Number of Sectors for Building Dimensions
C**   NQF    = Number of Variable Emission Rate Factors Per Source
C**   NPDMAX = Max Number of Particle Diameter Categories Per Source
C**   NWSCAT = Number of Wind Speed Categories
C**   NKST   = Number of Stability Categories
C**   IXM    = Max Number of X-coord (Distance) Values Per Receptor Network
C**   IYM    = Max Number of Y-coord (Direction) Values Per Receptor Network
C**   NNET   = Max Number of Cartesian and/or Polar Receptor Networks
C**   NHR    = Number of Hours in Met Data Loop
C**   NPAIR  = Number of Pairs of TXCONC and IDCONC for TOXXFILE Output
C**   NWET   = Number of phases of precipitation (2 = liquid,frozen)
C**   NHIANN = Number of high period/annual averages to include in
C**                the summary page of the output file (formerly controlled
C**                by NVAL)
C**   NMXPM  = Number of high average H4H 24-hour averages to include
C**                in the summary table for post-1997 PM10 processing


C***********************************************************************
C     Model Constants Specified as Parameters
C***********************************************************************

      REAL, PARAMETER :: PI = 3.141593, TWOPI = 6.283185,
     &                   RTOFPI = 1.772454, SRT2PI = 2.506628,
     &                   BETA = 0.6, G = 9.80616, DTORAD = 0.017453293,
     &                   RTODEG = 57.29578, VK = 0.4,RTPIBY2 = 1.2533141

C**   PI     = PI
C**   TWOPI  = 2.*PI
C**   RTOFPI = SQRT(PI)
C**   SRT2PI = SQRT(2.*PI)
C**   BETA   = Entrainment Coefficient for BLP Rise
C**   G      = Acceleration Due to Gravity (m/s**2)
C**   DTORAD = Degrees to Radians Conversion Factor
C**   RTODEG = Radians to Degrees Conversion Factor
C**   VK     = von-Karman Constant
C**   RTPIBY2= SQRT(PI/2.)


C***********************************************************************
C     Programmer Specified Model Parameters
C***********************************************************************

      INTEGER, PARAMETER :: IFMAX=40, IKN=70, ISTRG=132, IERRN=147,
     &                      ILEN_FLD=80
C*#

C**   IFMAX  = Max Number of Fields Per Runstream Record
C**   IPN    = Number of Pathway IDs (Includes '**')
C**   IKN    = Number of Keywords
C**   ISTRG  = Length of Runstream Image Record
C**   IERRN  = Number of Error/Warning/Informational Messages
C**   ILEN_FLD = Length of Runstream Input Fields.  Also used to
C**              specify length of input filenames and formats.


C***********************************************************************
C     Common Block for Input/Output File Units (Initialized in BLOCK DATA)
C***********************************************************************

      INTEGER ::      INUNIT, IOUNIT, MFUNIT, IERUNT, IERWRT,
     &                IDPUNT, IDPUN2, IRSUNT, IEVUNT, ITEVUT,
     &                IZUNIT, INCUNT

C*----   ISCSTM Modification: allow for hourly emissions - jah 11/3/94                                
     &               ,IHREMI
C*#


C**   INUNIT = Input Runstream File Unit (Initialized to 5)
C**   IOUNIT = Main Printed Output File Unit (Initialized to 6)
C**   MFUNIT = Input Meteorological Data File Unit (Initialized to 19)
C**   IERUNT = Temporary Error/Message File Unit (Initialized to 10)
C**   IERWRT = Permanent Detailed Error/Message File Unit (Init. to 11)
C**   IDPUNT = Main SAVEFILE Unit for Re-start Option (Init. to 12)
C**   IDPUN2 = Secondary SAVEFILE Unit for Re-start Option (Init. to 14)
C**   IRSUNT = INITFILE Unit for Re-start Option (Initialized to 15)
C**   IEVUNT = Event File Unit for Use With ISC2EV Model (Init. to 17)
C**   ITEVUT = Temporary Event File Used to Store High Value Events for
C**            Summary Tables and for EVENTFIL Option (Initialized to 18)
C**   IZUNIT = Gridded Terrain File Used (Initialized to 13)
C**   IHREMI = Hourly Emission Parameters File Unit (Init. to 16)
C**   INCUNT = INCLUDED File Unit (Initialized to 20)

C***********************************************************************
C     This is The Global Variable Definition Block for Runstream Data
C***********************************************************************

      LOGICAL BLINE, INFLD, MARK, ECHO

      CHARACTER PATH*2, PPATH*2, KEYWRD*8, PKEYWD*8, KEYWD*8, KTYPE*5,
     &          RUNST*1

      CHARACTER (LEN=ILEN_FLD) :: FIELD, INPFIL, OUTFIL, INCFIL
      CHARACTER (LEN=ISTRG)    :: RUNST1

      INTEGER ::      LOCB(IFMAX), LOCE(IFMAX), IFC, IDC1, IPNUM, IPPNUM
      DIMENSION       FIELD(IFMAX), KEYWD(IKN), RUNST(ISTRG)


C***********************************************************************
C     This is The Global Variable Definition Block for Error Handling
C***********************************************************************

      LOGICAL FATAL, ISTART, IFINIS, RECERR, ERRLST, EOF

      CHARACTER ERRMSG*50, ERRCOD*3, VERSN*5
      CHARACTER (LEN=ILEN_FLD) :: MSGFIL

      DIMENSION       ERRMSG(IERRN), ERRCOD(IERRN)
      INTEGER ::      ILINE, IERROR, IFTL, IWRN, INFO,
     &                ICLM, IMSG, IHEZ, NFATAL, IPAGE
      REAL ::         EXPLIM
      INTEGER ::      ICSTAT(25), ISSTAT(25), IRSTAT(25), IMSTAT(25),
     &                IOSTAT(25), ITSTAT(25), IESTAT(25)
      INTEGER ::      INCSET, IXYSET, IEVSET, IFGSET


C***********************************************************************
C     This is The Global Variable Definition Block for COntrol Pathway
C***********************************************************************

      LOGICAL DFAULT, CONC, DEPOS, DDEP, WDEP, RURAL, URBAN,
     &        GRDRIS, NOSTD, NOBID, NOCALM, CLMPRO, MSGPRO,
     &        PERIOD, ANNUAL, MONTH, FLAT, ELEV, FLGPOL,
     &        RUN, EVENTS, RSTSAV, RSTINP, DAYTAB, MXFILE, PPFILE,
     &        PLFILE, ANPOST, ANPLOT, STATOK, DEBUG, FSTREC, MULTYR,
     &        TXFILE, DDPLETE, WDPLETE, NOSMPL, NOCMPL, FSTCMP,
     &        EVONLY, SOCONT, DETAIL, NEWMET, SEASONHR, ARDPLETE,
     &        PM10AVE

C*----   ISCSTM Modification: allow for NOCHKD option - jah 11/2/94
     &       ,NOCHKD
C        RWB/MJ - allow for SCIM option - May, 1998.
     &       ,SCIM, WETSCIM, SCIMHR, WETHR, FIRSTWET, TOXICS,
     &        HEGTZI
C*#

      CHARACTER ELTYPE*6, TITLE1*68, TITLE2*68, EVPARM*6, CHRAVE*5,
     &          CHIDEP*4, MODOPS*6, SOELEV*6, REELEV*6, TGELEV*6,
     &          OUTTYP*5

      CHARACTER (LEN=ILEN_FLD) :: SAVFIL, SAVFL2, INIFIL, EVFILE

      INTEGER ::  NHIVAL, NMXVAL, NDUMP

      INTEGER ::  NSRC, NREC, NGRP, NAVE, NVAL, NTYP, NMAX,
     &            NQF, NPDMAX, NNET, IXM, IYM,
     &            NEVE, NUMEVE, IEVENT

      INTEGER, ALLOCATABLE :: KAVE(:)

     
      ALLOCATABLE ::  CHRAVE(:), CHIDEP(:,:), OUTTYP(:)
      DIMENSION       MODOPS(19)



C***********************************************************************
C     This is The Global Variable Definition Block for SOurce Pathway
C***********************************************************************

      CHARACTER SRCID*8, SRCTYP*8, SOPCRD*1, SOGAS*1, GRPID*8,
     &          EMILBL*40, OUTLBL*40, POLLUT*8, PSOID*8, QFLAG*6,
     &          PERLBL*40

C*----   ISCSTM Modification: allow for hourly emissions - jah 11/3/94
      CHARACTER (LEN=ILEN_FLD) :: HRFILE
C*#
      CHARACTER PREVGRPID*8
     
      LOGICAL LDPART, LWPART, LDGAS, LWGAS

      REAL, ALLOCATABLE ::    AXS(:), AYS(:), AZS(:), AQS(:),
     &                        AHS(:), ATS(:), AVS(:), ADS(:),
     &                        ASYINI(:), ASZINI(:)
      REAL, ALLOCATABLE ::    ADSBH(:,:), ADSBW(:,:)
      INTEGER, ALLOCATABLE :: IDSWAK(:,:), INPD(:)
      REAL, ALLOCATABLE ::    QFACT(:,:)
      REAL ::         EMICON, HAFLIF, DECOEF, VAIRMS, ZRDEP, VDPHOR
      REAL, ALLOCATABLE ::    EMIFAC(:), APDIAM(:,:), APHI(:,:),
     &                        APDENS(:,:), ASC(:,:),
     &                        AVGRAV(:,:), ATSTOP(:,:),
     &                        APSLIQ(:,:), APSICE(:,:),
     &                        AGSCAV(:,:)
     &

C*----   ISCSTM Modification: allow for hourly emissions - jah 11/3/94
      REAL ::     HRQS, HRTS, HRVS
      REAL, ALLOCATABLE ::  EV_HRQS(:,:), EV_HRTS(:,:), EV_HRVS(:,:)
      INTEGER ::  KURHRQ
C*----     
C*#

      INTEGER, ALLOCATABLE :: IGROUP(:,:)
      ALLOCATABLE ::  SRCID(:), SRCTYP(:), SOPCRD(:),
     &                SOGAS(:),
     &                GRPID(:), QFLAG(:), EMILBL(:),
     &                OUTLBL(:),
     &                PERLBL(:)


C**   KURHRQ  Date/Time Stamp for Hourly Emissions Data
C**   HRFILE  Hourly Emissions Data File Name          
C*#

C***********************************************************************
C     This is The Global Variable Definition Block for the New Area
C     Source Algorithm - 7/7/93
C
C*    Added XVERT,YVERT - Jayant Hardikar, PES, 7/20/94
C***********************************************************************

      INTEGER, PARAMETER :: NVMAX = 24, NVMAX2 = NVMAX*2

C**   NVMAX = Maximum Number of Vertices in a Single Area Source + 4
C**   NVMAX2= NVMAX * 2
C**   Note that the '+ 4' added to number of vertices for NVMAX refers
C**   to the maximum number of sides on an AREAPOLY source that a
C**   straight line can intersect.  For complex shapes, '+ 4' may not
C**   by large enough.  R. Brode, PES, Inc.

      LOGICAL LSEG

      INTEGER ::      IVERT, NVERT, NSEGS
     &
      REAL ::         UVERT(NVMAX), VVERT(NVMAX), VNVERT(NVMAX),
     &                WVERT(NVMAX), UASEGS(NVMAX), UBSEGS(NVMAX),
     &                XVERT(NVMAX), YVERT(NVMAX)
      REAL ::         SPA(NVMAX,2)
      REAL, ALLOCATABLE :: AXINIT(:), AYINIT(:), AANGLE(:),
     &                     AXVERT(:,:), AYVERT(:,:),
     &                     RADIUS(:), AXCNTR(:), AYCNTR(:)
      INTEGER, ALLOCATABLE :: NVERTS(:)



C***********************************************************************
C     This is The Global Variable Definition Block for the New OPENPIT
C     Source Algorithm - 7/19/94
C***********************************************************************

      REAL, PARAMETER   :: ALPHA = 0.029
      REAL, ALLOCATABLE :: AALPHA(:), APDEFF(:), AVOLUM(:)
      REAL, ALLOCATABLE :: EFRAC(:), QPART(:)
      REAL ::  PALPHA, THETA, PDEFF, PDREL, PITFRA, QEFF
      REAL ::  PITLEN, PITWID, PITL, EMIHGT, XEFF, YEFF

      
C*    ALPHA     = Proportionality Constant for determining Escape Fraction
C*    AALPHA    = Array of Angles of Long Pit Dimension w.r.t. 
C*                North for Each Source
C*    PALPHA    = Angle of Long Pit Dimension w.r.t. North for
C*                the Current Source
C*    THETA     = Wind Direction angle w.r.t Long Axis
C*                of the Pit
C*    APDEFF    = Array of Effective Pit Depths for Each Source
C*    PDEFF     = Effective Pit Depths for Current Source
C*    PDREL     = Relative Pit Depth
C*    AVOLUM    = Array of Volume of the OPENPIT Sources
C*    EFRAC     = Array of Escape Fractions
C*    QPART     = Array of Adjusted Emission Rates 
C*    PITFRA    = Fractional Size of the Effective Pit Area
C*    PITLEN    = Length of the Pit
C*    PITWID    = Width of the Pit
C*    PITL      = Along-Wind Length of the Pit
C*    EMIHGT    = Height of Emissions Above Base of Pit
C*    XEFF      = X-dimension of Effective Pit
C*    YEFF      = Y-dimension of Effective Pit

      
      
c----------------------------------------------------------------------
c --- COMMON BLOCK /DRYGAS/ -- Dry deposition parameters        CALPUFF
c----------------------------------------------------------------------
c
      REAL, ALLOCATABLE :: pdiff(:),alphas(:),react(:),
     1 rm(:),henry(:),rgg(:),rgw1(:),rcut(:),
     2 rd1(:)
      REAL :: rcutr,rgr,reactr,pconst,bmin,bmax,qswmax,dconst1,
     1 dconst2,dconst3,
     2 qsw,xlai,vdepg,uservd
CLF90      REAL ::       pdiff(NSRC),alphas(NSRC),react(NSRC),
CLF90     1 rm(NSRC),henry(NSRC),rgg(NSRC),rgw1(NSRC),rcut(NSRC),
CLF90     2 rd1(NSRC),rcutr,rgr,reactr,pconst,bmin,bmax,qswmax,dconst1,
CLF90     3 dconst2,dconst3,
CLF90     4 qsw,xlai,vdepg,uservd

      CHARACTER*40  REFSPE

      LOGICAL  UNSTRESSED, STRESSED, INACTIVE, LUSERVD
C
C     REFSPE      - Reference Species (Default is SO2)
C     UNSTRESSED  - Logical for state of unirrigated vegetation
C     STRESSED    - Logical for state of unirrigated vegetation
C     INACTIVE    - Logical for state of unirrigated vegetation
c
c --- COMMON BLOCK /DRYGAS/ Variables:
c       PDIFF(NSRC) - real    - Molecular diffusivity (m**2/s)
c                               of each pollutant.
c                               SEE NOTE #1
c      ALPHAS(NSRC) - real    - Solubility enhancement factor due
c                               to the aqueous phase reactivity of
c                               the pollutant.
c       REACT(NSRC) - real    - Reactivity factor for each
c                               pollutant.
c          RM(NSRC) - real    - Mesophyll resistance (s/m)
c                               SEE NOTE #2
c       HENRY(NSRC) - real    - Henry's law constant (ratio of
c                               gas to aqueous phase concentration
c                               of the pollutant).
c         RGG(NSRC) - real    - Resistance (s/m) to direct
c                               transfer of the pollutant to the
c                               ground.
c        RGW1(NSRC) - real    - Ratio of HENRY(i)/(ALPHAS(i)*d3)
c                               where d3 is a constant.  Used in
c                               computing resistance directly to
c                               water surface.
c        RCUT(NSRC) - real    - Cuticle resistance (s/m).
c         RD1(NSRC) - real    - Ratio d1*SC**d2/k, where d1,d2 are
c                               constants, SC is the Schmidt
c                               number, and k is the von Karman
c                               constant
c             RCUTR - real    - Reference cuticle resistance (s/m)
c                               SEE NOTE #2
c               RGR - real    - Reference ground resistance (s/m)
c                               SEE NOTE #2
c            REACTR - real    - Reference pollutant reactivity
c            PCONST - real    - Stomatal constant (m**2)
c              BMIN - real    - Minimum width of the stomatal
c                               opening (m)
c              BMAX - real    - Maximum width of the stomatal
c                               opening (m)
c            QSWMAX - real    - Short-wave solar radiation (W/m**2)
c                               level at which full opening of the
c                               stomata occurs
c   DCONST1,DCONST2 - real    - Empirical constants in deposition
c                               layer resistance equation
c           DCONST3 - real    - Constant in the "ground" resistance
c                               to water surfaces
c
c  NOTE #1: Input units of this variable are cm**2/s.  Conversion to m**2/s
c           is made internally in the SETUP phase.
c
c  NOTE #2: Input units of s/cm are converted to s/m in the SETUP phase.


      
C***********************************************************************
C     This is The Global Variable Definition Block for REceptor Pathway
C***********************************************************************

      LOGICAL ISTA, IEND, NEWID

      CHARACTER NETID*8, NETIDT*8, PNETID*8, NTID*8, NTTYP*8,
     &          RECTYP*2, PXSOID*8, PESOID*8

      REAL, ALLOCATABLE ::    AXR(:), AYR(:), AZELEV(:),
     &                        AZFLAG(:)
      INTEGER, ALLOCATABLE :: IREF(:)
      ALLOCATABLE ::          NETID(:), RECTYP(:), NTID(:),
     &                        NTTYP(:)
      INTEGER ::      ICOUNT, JCOUNT, IZE, IZF, IRZE, IRZF, IRXR, IRYR,
     &                IBND, IBELEV, INNET
      REAL ::         XINT, YINT
      REAL, ALLOCATABLE ::    XCOORD(:,:), YCOORD(:,:),
     &                        XORIG(:), YORIG(:)
      INTEGER, ALLOCATABLE :: NETSTA(:), NETEND(:),
     &                        NUMXPT(:), NUMYPT(:)



C***********************************************************************
C     This is The Global Variable Definition Block for MEteorology Pathway
C***********************************************************************

      CHARACTER SFNAME*40, UANAME*40

      CHARACTER (LEN=ILEN_FLD) :: METFRM, METINP, SCIMFIL
      LOGICAL SCIMOUT

      INTEGER ::      ISDATE, IEDATE, ISYR, ISMN, ISDY, ISHR, IEYR,
     &                IEMN, IEDY, IEHR, IPROC(366),
     &                ISYEAR, IUYEAR, IDSURF,
     &                IDUAIR, ISJDAY, IEJDAY,
     &                NDAYS, INCRST,
     &                ISTRT_CENT, ISTRT_WIND
C        RWB/MJ - allow for SCIM option - May, 1998.
     &               ,NREGSTART, NREGINT, IFIRSTHR, ISUNIT
     &               ,NSKIPTOT, NSKIPWET, NSKIPDRY
     &               ,NSWETCLM, NSDRYCLM, NSWETMSG, NSDRYMSG
     &               ,NWETHR, NWETINT, NWETSTART

      REAL ::         PUSER(NKST,NWSCAT), DTUSER(NKST,NWSCAT),
     &                PURB(NKST), PRUR(NKST), DTURB(NKST), DTRUR(NKST),
     &                UCAT(5), ZREF, ROTANG, UMIN,
     &                VIRTPNT_URB(NKST), VIRTPNT_RUR(NKST), VP_FACT


C***********************************************************************
C     This is The Global Variable Definition Block for METEXT
C***********************************************************************

      LOGICAL CLMHR, MSGHR, UNSTAB, NEUTRL, STABLE,
     &        RUNERR, NEWDAY, ENDMON, USERP, USERDT

      INTEGER ::      KSTMSG
      INTEGER ::      IHOUR, IYEAR, IMONTH, IDAY, KURDAT, JDAY, ISEAS,
     &                IPHOUR, IPDATE, IPCODE, KST,
     &                IYR, IDAY_OF_WEEK
      INTEGER ::      FULLDATE
      REAL ::         AFV, UREF, TA, ZI, ZIRUR, ZIURB,
     &                AFVLST, AFV24, S, RTOFS,
     &                USTAR, EL, Z0M, PRATE, UREF10

      INTEGER :: IKST(NHR), IAPCODE(NHR)
      REAL :: AUREF(NHR), ATA(NHR), AAFV(NHR), AAFVR(NHR), AZI(2,NHR)
      REAL :: APROF(NHR), ADTDZ(NHR), AUSTAR(NHR), AEL(NHR), AZ0M(NHR),
     &        APRATE(NHR), AQSW(NHR), AXLAI(NHR)

      INTEGER :: IENDHOUR, IENDDY, IENDMN, NUMYRS, NREMAIN

C***********************************************************************
C     This is The Global Variable Definition Block for Terrain Grid Pathway
C***********************************************************************

      CHARACTER (LEN=ILEN_FLD) :: TERINP
      LOGICAL LTGRID

      REAL ::     TGX0, TGY0, GRDXLL, GRDXUR, GRDYLL, GRDYUR, XYINT


C***********************************************************************
C     This is The Global Variable Definition Block for Calculation
C***********************************************************************

      LOGICAL CALCS, WAKE, WAKESS, WAKLOW, BUOYNT, TALL, SQUAT, SSQUAT

      INTEGER ::      IREC,   ISRC,   IGRP,   IAVE,   ITYP,  ISET,
     &                NUMREC, NUMSRC, NUMGRP, NUMAVE, NUMTYP,
     &                NUMYR, ICYEAR, NPD, IFVSEC, IUCAT
      REAL ::         XS, YS, ZS, QS, HS, DS, VS, TS, SYINIT,
     &                SZINIT, XINIT, YINIT, ANGLE, XCNTR, YCNTR,
     &                DSBH, DSBW, D, VD, E, WDRAD, WDSIN, WDCOS
      REAL, ALLOCATABLE :: V(:)
C                        Accomodate Wet SCIM'ing, M. Jindal, PES, 6/10/98
     &                    ,VDRY(:)
      REAL, ALLOCATABLE :: PDIAM(:), PHI(:), PDENS(:),
     &                     SC(:), VGRAV(:), TSTOP(:),
     &                     VDEP(:),
     &                     WQCOR(:), WQCORC(:),
     &                     SZCOR(:), SZCORC(:), SZMIN(:),
     &                     DQCOR(:), PCORZR(:), PCORZD(:),
     &                     DQCORC(:), PCORZRC(:), PCORZDC(:),
     &                     PSCAV(:,:), GSCAV(:),
     &                     PSCVRT(:)
      REAL ::         SZCORG, SZCORGC, WQCORG, WQCORGC, GSCVRT,
     &                DQCORG, PCORZRG, PCORZDG,
     &                DQCORGC, PCORZRGC, PCORZDGC
      REAL ::         XR, YR, X, Y, ZELEV, ZFLAG, DISTR
      REAL ::         HE, HSP, HEFLAT, HTER, HEMWAK, ZB, ZM,
     &                XY, XZ, SBID, FM, FB, DTDZ, DHF, DHP, DELT,
     &                DHPB, DHPM, XF, XFM, XFB, XRAD
      REAL ::         US, SY, SZ, DA, ZLY, ZLB, X3LB, RINIT,
     &                CB, CM, QTK, P


C***********************************************************************
C     This is The Global Variable Definition Block for Complex Terrain
C***********************************************************************

      LOGICAL SIMPLE, INTERM, COMPLX

      REAL ::         TCF(NKST), ZMIN, HECMP1, HECOMP, HESETL,
     &                CORR, DELTHP, XZCMP1, SZCMP1, SBCMP1,
     &                DHPCMP, DHFCMP,
     &                SIMCON, COMCON


C***********************************************************************
C     This is The Global Variable Definition Block for EVent Pathway
C***********************************************************************

      CHARACTER EVNAME*8, EVGRP*8
      INTEGER, ALLOCATABLE ::  EVAPER(:), EVDATE(:), EVJDAY(:),
     &                         IDXEV(:)

      ALLOCATABLE ::  EVNAME(:), EVGRP(:)




C***********************************************************************
C     This is The Global Variable Definition Block for OUtput Pathway
C***********************************************************************

      CHARACTER (LEN=ILEN_FLD) :: THRFIL, PSTFIL, PLTFIL, ANNPST,
     &                            ANNPLT, THRFRM, PSTFRM, PLTFRM,
     &                            TOXFIL, SEAHRS

      INTEGER, ALLOCATABLE :: NHIAVE(:,:), MAXAVE(:), IMXVAL(:),
     &                        IDYTAB(:), MAXFLE(:,:),
     &                        IPSTFL(:,:), IPLTFL(:,:,:),
     &                        IANPST(:), IANPLT(:), INHI(:),
     &                        ITOXFL(:), ISEAHR(:)
      REAL, ALLOCATABLE ::    THRESH(:,:), TOXTHR(:)
      INTEGER, ALLOCATABLE :: IMXUNT(:,:), IPSUNT(:,:),
     &                        IPSFRM(:,:), IPLUNT(:,:,:),
     &                        IAPUNT(:), IANFRM(:), IPPUNT(:),
     &                        ITXUNT(:), ISHUNT(:)

      ALLOCATABLE ::  THRFIL(:,:), PSTFIL(:,:),
     &                PLTFIL(:,:,:), ANNPST(:),
     &                ANNPLT(:), TOXFIL(:), SEAHRS(:)

      INTEGER, ALLOCATABLE :: IDCONC(:,:)

      INTEGER ::      ITAB, NXTOX, NYTOX, NHOURS, IPAIR

      REAL, ALLOCATABLE ::    TXCONC(:,:)



C***********************************************************************
C     This is The Global Variable Definition Block for Working Space
C***********************************************************************

      CHARACTER WORKID*8, DUMMY*8

      INTEGER     :: IMIT, INUM, IDUM, INDAVE, INDGRP, INDVAL,
     &               ISC, IOERRN, NCPP, NRPP, NGPP, NPPX, NPPY
      REAL        :: FNUM, RNUM

      ALLOCATABLE ::          WORKID(:)
      INTEGER, ALLOCATABLE :: IWRK2(:,:)

C     Declare Temporary Work Arrays for ZELEV and ZFLAG Receptor Data
      REAL, ALLOCATABLE :: ZETMP1(:), ZETMP2(:)
      REAL, ALLOCATABLE :: ZFTMP1(:), ZFTMP2(:)


      SAVE

C***********************************************************************
C     Formerly MAIN3.INC
C     ISCST2 Model Data - Array Names, Array Limits, Named Common Blocks
C                         Necessary for Model Results
C     MODIFIED - 4/17/95   Output CONC/DEPOS in same model run
C***********************************************************************


C***********************************************************************
C     This is The Global Variable Definition Block For The Maximum
C     Value, Highest Value, Average Value, Annual Average Value and
C     Model Result Arrays.  Also Included are Calm/Missing Flag Arrays.
C***********************************************************************


      CHARACTER HCLMSG, MCLMSG, HMCLM

      REAL,    ALLOCATABLE ::  HRVAL(:), SIMPL(:), COMPL(:),
     &                         AVEVAL(:,:,:,:)
C                             Accomodate Wet SCIM'ing, M. Jindal, PES, 6/10/98
     &                        ,HRVALD(:),HRVALJD(:,:)
     &                        ,SIMPLD(:),SIMPLJD(:,:)
     &                        ,COMPLD(:),COMPLJD(:,:)
      REAL,    ALLOCATABLE ::  HIVALU(:,:,:,:,:),
     &                         HMAX(:,:,:,:)
      INTEGER, ALLOCATABLE ::  HMLOC(:,:,:,:),
     &                         HMDATE(:,:,:,:),
     &                         NHIDAT(:,:,:,:,:)

      REAL,    ALLOCATABLE ::  ANNVAL(:,:,:), AMXVAL(:,:,:),
     &                         SHVALS(:,:,:,:,:)
C                             Accomodate Wet SCIM'ing, M. Jindal, PES, 6/10/98
     &                        ,ANNVALD(:,:,:), ANNVALW(:,:,:)
     &                        ,ANNVALJD(:,:,:,:), ANNVALJW(:,:,:,:)
      INTEGER, ALLOCATABLE ::  IMXLOC(:,:,:)
      INTEGER              ::  IANHRS, IANCLM, IANMSG,
     &                         NSEAHR(4,24), NSEACM(4,24)
C                             Accomodate Wet SCIM'ing, M. Jindal, PES, 6/10/98
     &                        ,IANWET, IWETCLM, IWETMSG
      REAL,    ALLOCATABLE ::  RMXVAL(:,:,:,:)
      INTEGER, ALLOCATABLE ::  MXDATE(:,:,:,:),
     &                         MXLOCA(:,:,:,:)
      INTEGER, ALLOCATABLE ::  NUMHRS(:), NUMCLM(:), NUMMSG(:)
      ALLOCATABLE ::           HCLMSG(:,:,:,:,:),
     &                         MCLMSG(:,:,:,:),
     &                         HMCLM(:,:,:,:)

      REAL,    ALLOCATABLE ::  SUMANN(:,:,:)
      REAL,    ALLOCATABLE ::  SUMH4H(:,:), MXPMVAL(:,:)
      INTEGER, ALLOCATABLE ::  MXPMLOC(:,:)


C***********************************************************************
C     This is The Global Variable Definition Block For The
C     EVENT Model Result Arrays
C***********************************************************************

      REAL, ALLOCATABLE ::  EV_AVEVAL(:), HRVALS(:,:), GRPVAL(:)

      REAL ::  GRPAVE
      INTEGER ::  EV_NUMHRS, EV_NUMCLM, EV_NUMMSG, ISTAHR, IENDHR


C***********************************************************************
C
C     BLOCK DATA SUBPROGRAM OF THE ISC - Version 2 MODEL
C
C     PURPOSE: Initialize Data in COMMON Blocks
C
C     MODIFIED:  To Include Terrain Grid pathway - 12/15/93
C
C     MODIFIED:  To Include WET DEPOSITION Arrays - 11/8/93
C
C     MODIFIED:  To Include New Area Source Arrays - 7/7/93
C
C     MODIFIED:  For revised DRY DEPOSITION code - 2/15/93
C
C     MODIFIED:  To Include TOXXFILE Option - 9/29/92
C
C***********************************************************************

C     Variable Declarations


C***********************************************************************
C     Initialize Model Version Number, VERSN (Year, Julian Day), as a
C     Character Variable
C***********************************************************************

      DATA VERSN /'02035'/


C***********************************************************************
C     Input/Output File Units and Input/Output File Names
C***********************************************************************

CLF95 Change INUNIT from 5 to 7, and IOUNIT from 6 to 8, for the
CLF95 Lahey LF95 compiler (version 5.0).
      DATA INUNIT/ 7/, IOUNIT/ 8/, MFUNIT/19/, IERUNT/10/,
     &     IERWRT/11/, IDPUNT/12/, IDPUN2/14/, IRSUNT/15/,     
     &     IEVUNT/17/, ITEVUT/18/, IZUNIT/13/,
     &     IHREMI/16/, INCUNT/20/, ISUNIT/ 9/
C*#
      DATA INPFIL/' '/, OUTFIL/' '/


C***********************************************************************
C     Initialize Keyword Array
C***********************************************************************

      INTEGER, PRIVATE :: I

      DATA (KEYWD(I),I=1,IKN) /'STARTING','FINISHED','TITLEONE',
     &   'TITLETWO','MODELOPT','AVERTIME','POLLUTID','HALFLIFE',
     &   'DCAYCOEF','TERRHGTS','ELEVUNIT','FLAGPOLE','RUNORNOT',
     &   'EVENTFIL','SAVEFILE','INITFILE','MULTYEAR','ERRORFIL',
     &   'GASDEPRF','VEGSTATE','GASDEPVD','EVENTFIL',
     &   'LOCATION','SRCPARAM','BUILDHGT','BUILDWID','LOWBOUND',
     &   'EMISFACT','EMISUNIT','PARTDIAM','MASSFRAX','PARTDENS',
     &   'PARTSLIQ','PARTSICE','GAS-SCAV','CONCUNIT','DEPOUNIT',
     &   'HOUREMIS','GASDEPOS','EVENTPER','EVENTLOC',
     &   'SRCGROUP','GRIDCART','GRIDPOLR','DISCCART','DISCPOLR',
     &   'BOUNDARY','BOUNDELV','INPUTFIL','ANEMHGHT','SURFDATA',
     &   'UAIRDATA','STARTEND','DAYRANGE','WDROTATE','WINDPROF',
     &   'DTHETADZ','WINDCATS','RECTABLE','MAXTABLE','DAYTABLE',
     &   'MAXIFILE','POSTFILE','PLOTFILE','TOXXFILE','EVENTOUT',
     &   'INCLUDED','SCIMBYHR','SEASONHR','AREAVERT'/


C***********************************************************************
C     Initialize Miscellaneous Variables
C***********************************************************************

      DATA IPROC /366*1/, EXPLIM /-50.0/
      DATA UCAT /1.54, 3.09, 5.14, 8.23, 10.8/
      DATA MODOPS /19*'      '/


C***********************************************************************
C     Initialize Default Wind Profile Exponents and DTHETADZ
C***********************************************************************

C     STAB. CLASS         A    B     C     D      E      F
C                        ***  ***   ***   ***    ***    ***
      DATA DTURB         /0.,  0.,   0.,   0.,   0.02, 0.035/,
     &     DTRUR         /0.,  0.,   0.,   0.,   0.02, 0.035/,
     &     PURB         /0.15, 0.15, 0.20, 0.25, 0.30, 0.30/,
     &     PRUR         /0.07, 0.07, 0.10, 0.15, 0.35, 0.55/,
     &     VIRTPNT_URB  /3.5,  3.5,  5.5,  10.5, 15.5, 15.5/,
     &     VIRTPNT_RUR  /3.5,  5.5,  7.5,  12.5, 15.5, 25.5/


C***********************************************************************
C     Initialize Setup Status Arrays
C***********************************************************************

      DATA ICSTAT/25*0/, ISSTAT/25*0/, IRSTAT/25*0/, IMSTAT/25*0/,
     &     IOSTAT/25*0/, ITSTAT/25*0/


c
c --- DRYGAS common block
      data rcutr/30.0/,rgr/10.0/,reactr/8.0/
      data pconst/2.3e-8/,bmax/2.5e-6/,bmin/0.1e-6/,qswmax/600./
      data dconst1/2.0/,dconst2/0.6666667/,dconst3/4.8e-4/

C***********************************************************************
C     Initialize Error Code and Message Arrays
C***********************************************************************

      DATA ERRCOD(1)/'100'/,
     &  ERRMSG(1)/'Invalid Pathway Specified. The Troubled Pathway is'/
      DATA ERRCOD(2)/'105'/,
     &  ERRMSG(2)/'Invalid Keyword Specified. The Troubled Keyword is'/
      DATA ERRCOD(3)/'110'/,
     &  ERRMSG(3)/'Keyword is Not Valid for This Pathway.  Keyword is'/
      DATA ERRCOD(4)/'115'/,
     &  ERRMSG(4)/'STARTING or FINISHED Out of Sequence:  Pathway =  '/
      DATA ERRCOD(5)/'120'/,
     &  ERRMSG(5)/'Pathway is Out of Sequence:  Pathway =            '/
      DATA ERRCOD(6)/'125'/,
     &  ERRMSG(6)/'Missing FINISHED-Runstream File Incomplete: ISTAT='/
      DATA ERRCOD(7)/'130'/,
     &  ERRMSG(7)/'Missing Mandatory Keyword.  The Missing Keyword is'/
      DATA ERRCOD(8)/'135'/,
     &  ERRMSG(8)/'Duplicate Nonrepeatable Keyword Specified:Keyword='/
      DATA ERRCOD(9)/'140'/,
     &  ERRMSG(9)/'Invalid Order of Keyword.  The Troubled Keyword is'/
      DATA ERRCOD(10)/'145'/,
     &  ERRMSG(10)/'Conflicting Options: MULTYEAR and Re-Start Option '/
      DATA ERRCOD(11)/'150'/,
     &  ERRMSG(11)/'Conflicting Options: MULTYEAR for Wrong Pollutant '/
      DATA ERRCOD(12)/'155'/,
     &  ERRMSG(12)/'Conflicting Decay Keyword. Inputs Ignored for     '/
      DATA ERRCOD(13)/'160'/,
     &  ERRMSG(13)/'Duplicate ORIG Secondary Keyword for GRIDPOLR:    '/
      DATA ERRCOD(14)/'170'/,
     &  ERRMSG(14)/'Invalid Secondary Keyword for Receptor Grid:      '/
      DATA ERRCOD(15)/'175'/,
     &  ERRMSG(15)/'Missing Secondary Keyword END for Receptor Grid:  '/
      DATA ERRCOD(16)/'180'/,
     &  ERRMSG(16)/'Conflicting Secondary Keyword for Receptor Grid:  '/
      DATA ERRCOD(17)/'185'/,
     &  ERRMSG(17)/'Missing Receptor Keywords. No Receptors Specified.'/
      DATA ERRCOD(18)/'190'/,
     &  ERRMSG(18)/'No Keywords for OU Path and No PERIOD/ANNUAL Aves.'/
      DATA ERRCOD(19)/'195'/,
     &  ERRMSG(19)/'Incompatible Option Used With SAVEFILE or INITFILE'/
      DATA ERRCOD(20)/'200'/,
     &  ERRMSG(20)/'Missing Parameter(s). No Options Specified For    '/
      DATA ERRCOD(21)/'201'/,
     &  ERRMSG(21)/'Not Enough Parameters Specified For the Keyword of'/
      DATA ERRCOD(22)/'202'/,
     &  ERRMSG(22)/'Too Many Parameters Specified For the Keyword of  '/
      DATA ERRCOD(23)/'203'/,
     &  ERRMSG(23)/'Invalid Parameter Specified.  Troubled Parameter: '/
      DATA ERRCOD(24)/'204'/,
     &  ERRMSG(24)/'Option Parameters Conflict.  Forced by Default to '/
      DATA ERRCOD(25)/'205'/,
     &  ERRMSG(25)/'No Option Parameter Setting.  Forced by Default to'/
      DATA ERRCOD(26)/'206'/,
     &  ERRMSG(26)/'Regulatory DFAULT Overrides Non-DFAULT Option For '/
      DATA ERRCOD(27)/'207'/,
     &  ERRMSG(27)/'No Parameters Specified. Default Values Will Used.'/
      DATA ERRCOD(28)/'208'/,
     &  ERRMSG(28)/'Illegal Numerical Field Encountered in            '/
      DATA ERRCOD(29)/'209'/,
     &  ERRMSG(29)/'Negative Value Appears For Non-negative Variable. '/
      DATA ERRCOD(30)/'210'/,
     &  ERRMSG(30)/'Number of Short Term Averages Exceeds Max:  NAVE= '/
      DATA ERRCOD(31)/'211'/,
     &  ERRMSG(31)/'Duplicate Averaging Period Specified for Keyword  '/
      DATA ERRCOD(32)/'212'/,
     &  ERRMSG(32)/'END Encountered Without (X,Y) Points Properly Set '/
      DATA ERRCOD(33)/'213'/,
     &  ERRMSG(33)/'ELEV Input Inconsistent With Option: Input Ignored'/
      DATA ERRCOD(34)/'214'/,
     &  ERRMSG(34)/'ELEV Input Inconsistent With Option: Defaults Used'/
      DATA ERRCOD(35)/'215'/,
     &  ERRMSG(35)/'FLAG Input Inconsistent With Option: Input Ignored'/
      DATA ERRCOD(36)/'216'/,
     &  ERRMSG(36)/'FLAG Input Inconsistent With Option: Defaults Used'/
      DATA ERRCOD(37)/'217'/,
     &  ERRMSG(37)/'More Than One Delimiter In A Field for Keyword    '/
      DATA ERRCOD(38)/'218'/,
     &  ERRMSG(38)/'Number of (X,Y) Points Not Match With Number Of   '/
      DATA ERRCOD(39)/'219'/,
     &  ERRMSG(39)/'Number Of Receptors Specified Exceeds Max:  NREC= '/
      DATA ERRCOD(40)/'220'/,
     &  ERRMSG(40)/'Missing Origin (Use Default = 0,0) In GRIDPOLR    '/
      DATA ERRCOD(41)/'221'/,
     &  ERRMSG(41)/'Missing Distance Setting In Polar Network         '/
      DATA ERRCOD(42)/'222'/,
     &  ERRMSG(42)/'Missing Degree Or Dist Setting In Polar Network   '/
      DATA ERRCOD(43)/'223'/,
     &  ERRMSG(43)/'Missing Distance or Degree Field in               '/
      DATA ERRCOD(44)/'224'/,
     &  ERRMSG(44)/'Number of Receptor Networks Exceeds Max:  NNET=   '/
      DATA ERRCOD(45)/'225'/,
     &  ERRMSG(45)/'Number of X-Coords Specified Exceeds Max:  IXM=   '/
      DATA ERRCOD(46)/'226'/,
     &  ERRMSG(46)/'Number of Y-Coords Specified Exceeds Max:  IYM=   '/
      DATA ERRCOD(47)/'227'/,
     &  ERRMSG(47)/'No Receptors Were Defined on the RE Pathway.      '/
      DATA ERRCOD(48)/'228'/,
     &  ERRMSG(48)/'Default(s) Used for Missing Parameters on Keyword '/
      DATA ERRCOD(49)/'229'/,
     &  ERRMSG(49)/'Too Many Parameters - Inputs Ignored on Keyword   '/
      DATA ERRCOD(50)/'230'/,
     &  ERRMSG(50)/'Not Enough Numerical Values Specified for         '/
      DATA ERRCOD(51)/'231'/,
     &  ERRMSG(51)/'Too Many Numerical Values Specified for           '/
      DATA ERRCOD(52)/'232'/,
     &  ERRMSG(52)/'Number Of Specified Sources Exceeds Maximum: NSRC='/
      DATA ERRCOD(53)/'233'/,
     &  ERRMSG(53)/'Building Dimensions Specified for Non-POINT Source'/
      DATA ERRCOD(54)/'234'/,
     &  ERRMSG(54)/'Too Many Sectors Input for                        '/
      DATA ERRCOD(55)/'235'/,
     &  ERRMSG(55)/'Number of Source Groups Exceeds Maximum:  NGRP=   '/
      DATA ERRCOD(56)/'236'/,
     &  ERRMSG(56)/'Not Enough BUILDHGTs Specified for SourceID       '/
      DATA ERRCOD(57)/'237'/,
     &  ERRMSG(57)/'Not Enough BUILDWIDs Specified for SourceID       '/
      DATA ERRCOD(58)/'238'/,
     &  ERRMSG(58)/'Not Enough LOWBOUNDs Specified for SourceID       '/
      DATA ERRCOD(59)/'239'/,
     &  ERRMSG(59)/'Not Enough QFACTs Specified for SourceID          '/
      DATA ERRCOD(60)/'240'/,
     &  ERRMSG(60)/'Inconsistent Number of Settling/Removal Cats for  '/
      DATA ERRCOD(61)/'242'/,
     &  ERRMSG(61)/'No Particle Cat. or Gas Depos. Specified for SRCID'/
      DATA ERRCOD(62)/'244'/,
     &  ERRMSG(62)/'Too Many Particle Categories Specified for        '/
      DATA ERRCOD(63)/'245'/,
     &  ERRMSG(63)/'No. of Settling/Removal Cats Exceeds Max:  NPDMAX='/
      DATA ERRCOD(64)/'248'/,
     &  ERRMSG(64)/'No Sources Were Defined on the SO Pathway.        '/
      DATA ERRCOD(65)/'250'/,
     &  ERRMSG(65)/'Duplicate XPNT/DIST or YPNT/DIR Specified for GRID'/
      DATA ERRCOD(66)/'252'/,
     &  ERRMSG(66)/'Duplicate Receptor Network ID Specified.  NETID = '/
      DATA ERRCOD(67)/'255'/,
     &  ERRMSG(67)/'Boundary Receptor Distances Not Defined Yet for   '/
      DATA ERRCOD(68)/'260'/,
     &  ERRMSG(68)/'Number of Emission Factors Exceeds Max:      NQF= '/
      DATA ERRCOD(69)/'270'/,
     &  ERRMSG(69)/'Number of High Values Specified Exceeds Max: NVAL='/
      DATA ERRCOD(70)/'280'/,
     &  ERRMSG(70)/'Number of Max Values Specified Exceeds Max:  NMAX='/
C     Message '290' specified below as array element 120.
      DATA ERRCOD(71)/'300'/,
     &  ERRMSG(71)/'Specified SRCID Has Not Been Defined Yet: KEYWORD='/
      DATA ERRCOD(72)/'310'/,
     &  ERRMSG(72)/'Attempt to Define Duplicate LOCATION Card for SRC:'/
      DATA ERRCOD(73)/'315'/,
     &  ERRMSG(73)/'Attempt to Define Duplicate SRCPARAM Card for SRC:'/
      DATA ERRCOD(74)/'320'/,
     &  ERRMSG(74)/'Input Parameter May Be Out-of-Range for Parameter '/
      DATA ERRCOD(75)/'325'/,
     &  ERRMSG(75)/'Negative Exit Velocity (Set=1.0E-5) for SRCID:    '/
      DATA ERRCOD(76)/'330'/,
     &  ERRMSG(76)/'Mass Fraction Parameters Do Not Sum to 1. for Src '/
      DATA ERRCOD(77)/'332'/,
     &  ERRMSG(77)/'Mass Fraction Parameter Out-of-Range for Source   '/
      DATA ERRCOD(78)/'334'/,
     &  ERRMSG(78)/'Particle Density Out-of-Range for Source          '/
      DATA ERRCOD(79)/'340'/,
     &  ERRMSG(79)/'Possible Error In ANHT of ANEMHGHT. The Value is  '/
      DATA ERRCOD(80)/'350'/,
     &  ERRMSG(80)/'Julian Day Out Of Range at                        '/
      DATA ERRCOD(81)/'360'/,
     &  ERRMSG(81)/'2-Digit Year Specified: Valid for Range 1950-2049 '/
      DATA ERRCOD(82)/'370'/,
     &  ERRMSG(82)/'Invalid Date: 2/29 In a Non-leap Year.            '/
      DATA ERRCOD(83)/'380'/,
     &  ERRMSG(83)/'This Input Variable is Out-of-Range:              '/
      DATA ERRCOD(84)/'385'/,
     &  ERRMSG(84)/'Averaging Period .NE. 1-Hr for TOXXFILE Option    '/
      DATA ERRCOD(85)/'400'/,
     &  ERRMSG(85)/'No Convergence Reached in SUB. CUBIC.  KURDAT=    '/
      DATA ERRCOD(86)/'410'/,
     &  ERRMSG(86)/'Flow Vector Out-of-Range.   KURDAT=               '/
      DATA ERRCOD(87)/'420'/,
     &  ERRMSG(87)/'Wind Speed Out-of-Range.   KURDAT=                '/
      DATA ERRCOD(88)/'430'/,
     &  ERRMSG(88)/'Ambient Temperature Data Out-of-Range.  KURDAT=   '/
      DATA ERRCOD(89)/'440'/,
     &  ERRMSG(89)/'Calm Hour Identified in Meteorology Data File at  '/
      DATA ERRCOD(90)/'450'/,
     &  ERRMSG(90)/'Error in Meteor. File - Record Out of Sequence at '/
      DATA ERRCOD(91)/'460'/,
     &  ERRMSG(91)/'Missing Hour Identified in Meteor. Data File at   '/
      DATA ERRCOD(92)/'470'/,
     &  ERRMSG(92)/'Mixing Height Value is < or = 0.0.   KURDAT=      '/
      DATA ERRCOD(93)/'500'/,
     &  ERRMSG(93)/'Fatal Error Occurs Opening the Data File of       '/
      DATA ERRCOD(94)/'510'/,
     &  ERRMSG(94)/'Fatal Error Occurs During Reading of the File of  '/
      DATA ERRCOD(95)/'520'/,
     &  ERRMSG(95)/'Fatal Error Occurs During Writing to the File of  '/
      DATA ERRCOD(96)/'530'/,
     &  ERRMSG(96)/'Error Occurs Reading Met Station or Year:File Says'/
      DATA ERRCOD(97)/'540'/,
     &  ERRMSG(97)/'No RECTABLE/MAXTABLE/DAYTABLE for Average Period  '/
      DATA ERRCOD(98)/'550'/,
     &  ERRMSG(98)/'File Unit/Name Conflict for the Output Option:    '/
      DATA ERRCOD(99)/'560'/,
     &  ERRMSG(99)/'User Specified File Unit < 21 for OU Keyword:     '/
      DATA ERRCOD(100)/'565'/,
     & ERRMSG(100)/'Possible Conflict With Dynamically Allocated FUNIT'/
      DATA ERRCOD(101)/'570'/,
     & ERRMSG(101)/'Problem Reading Temporary Event File for Event:   '/
      DATA ERRCOD(102)/'580'/,
     & ERRMSG(102)/'End of File Reached Trying to Read the File of    '/
      DATA ERRCOD(103)/'305'/,
     & ERRMSG(103)/'Terrain Grid Does Not Cover Modeling Area, Change:'/
      DATA ERRCOD(104)/'144'/,
     & ERRMSG(104)/'Conflicting Options: NOSMPL with FLAT Terrain     '/
      DATA ERRCOD(105)/'151'/,
     & ERRMSG(105)/'CO ELEVUNIT card obsolescent: use RE ELEVUNIT card'/
      DATA ERRCOD(106)/'152'/,
     & ERRMSG(106)/'ELEVUNIT card must be first for this Pathway:     '/
      DATA ERRCOD(107)/'153'/,
     & ERRMSG(107)/'Cannot use CO ELEVUNIT card with ELEVUNIT card for'/
      DATA ERRCOD(108)/'391'/,
     & ERRMSG(108)/'Aspect ratio (L/W) of area source greater than 10 '/
      DATA ERRCOD(109)/'392'/,
     & ERRMSG(109)/'Aspect ratio (L/W) of open pit is greater than 10 '/
      DATA ERRCOD(110)/'393'/,
     & ERRMSG(110)/'Terrain Grid Value Differs >50% From Source Elev. '/
      DATA ERRCOD(111)/'394'/,
     & ERRMSG(111)/'Terrain Grid Value Differs >50% From Receptor Elev'/
      DATA ERRCOD(112)/'322'/,
     & ERRMSG(112)/'Release Height Exceeds Effective Depth for OPENPIT'/
      DATA ERRCOD(113)/'243'/,
     & ERRMSG(113)/'Scav. Coef. may be out-of-range for SRCID         '/
C     Message 143 modified with version dated 00101. RWB
      DATA ERRCOD(114)/'143'/,
     & ERRMSG(114)/'UNFORM option not supported.  Convert data using  '/
      DATA ERRCOD(115)/'435'/,
     & ERRMSG(115)/'Surface Roughness Length Out-of-Range.  KURDAT=   '/


      DATA ERRCOD(116)/'342'/,
     & ERRMSG(116)/'Src ID Mismatch in Hourly Emissions File for ID = '/
      DATA ERRCOD(117)/'344'/,
     & ERRMSG(117)/'Hourly Emission Rate is Zero for KURDAT =         '/
C*----
C*#

      DATA ERRCOD(118)/'157'/,
     & ERRMSG(118)/'EMISUNIT Keyword Used With More Than 1 Output Type'/
      DATA ERRCOD(119)/'158'/,
     & ERRMSG(119)/'EMISUNIT Keyword Used With the Following Keyword: '/
      DATA ERRCOD(120)/'290'/,
     & ERRMSG(120)/'Number of Output Types Specified Exceeds Max:NTYP='/
      DATA ERRCOD(121)/'295'/,
     & ERRMSG(121)/'PERIOD and ANNUAL averages are both selected for  '/
      DATA ERRCOD(122)/'455'/,
     & ERRMSG(122)/'Date/time Mismatch: Hourly Emission File. KURDAT ='/
      DATA ERRCOD(123)/'323'/,
     & ERRMSG(123)/'No Particle Categories Specified for OPENPIT Src. '/
      DATA ERRCOD(124)/'197'/,
     & ERRMSG(124)/'Post-97 PM10 without MAXIFILE is incompatible with'/
      DATA ERRCOD(125)/'298'/,
     & ERRMSG(125)/'Error Allocating Storage for Setup Arrays!        '/
      DATA ERRCOD(126)/'299'/,
     & ERRMSG(126)/'Error Allocating Storage for Result Arrays!       '/

      DATA ERRCOD(127)/'262'/,
     & ERRMSG(127)/'First Vertex Does Not Match LOCATION for AREAPOLY '/
      DATA ERRCOD(128)/'264'/,
     & ERRMSG(128)/'Too Many Vertices Specified for AREAPOLY Source   '/
      DATA ERRCOD(129)/'265'/,
     & ERRMSG(129)/'Not Enough Vertices Specified for AREAPOLY Source '/

C     Add error/warning messages associated with post-1997 PM10 processing
      DATA ERRCOD(130)/'352'/,
     & ERRMSG(130)/'Missing Field on MULTYEAR Card for Pre-1997 PM10  '/
      DATA ERRCOD(131)/'353'/,
     & ERRMSG(131)/'MULTYEAR Card for PM10 Processing Applies Only for'/
      DATA ERRCOD(132)/'354'/,
     & ERRMSG(132)/'High-4th-High Only Required for Post-1997 PM10    '/
      DATA ERRCOD(133)/'363'/,
     & ERRMSG(133)/'24HR and ANNUAL Averages Only for Post-1997 PM10  '/
      DATA ERRCOD(134)/'480'/,
     & ERRMSG(134)/'Less Than 1 Year Found for ANNUAL Averages        '/
      DATA ERRCOD(135)/'485'/,
     & ERRMSG(135)/'Data Remaining After End of Year. Number of Hours='/

      DATA ERRCOD(136)/'487'/,
     & ERRMSG(136)/'User Start Date is Earlier Than Start of Data File'/
      DATA ERRCOD(137)/'319'/,
     & ERRMSG(137)/'No Sources Included in Specified Source Group:    '/
      DATA ERRCOD(138)/'313'/,
     & ERRMSG(138)/'Attempt to Define Duplicate EVENTPER card for     '/
      DATA ERRCOD(139)/'413'/,
     & ERRMSG(139)/'Number of Threshold Events > 9999 for Ave Period  '/
      DATA ERRCOD(140)/'405'/,
     & ERRMSG(140)/'Increase NVMAX for Complex AREAPOLY Source        '/

      DATA ERRCOD(141)/'196'/,
     & ERRMSG(141)/'Incompatible Keyword Used With GASDEPVD           '/
      DATA ERRCOD(142)/'154'/,
     & ERRMSG(142)/'Conflicting options:  SCIM cannot be used with    '/
      DATA ERRCOD(143)/'156'/,
     & ERRMSG(143)/'Option ignored - not valid with SCIM.  Option =   '/
      DATA ERRCOD(144)/'198'/,
     & ERRMSG(144)/'TOXICS Option is Required in Order to Use Option  '/

C     Add error message for year exceeding 2147.
      DATA ERRCOD(145)/'365'/,
     & ERRMSG(145)/'Year Input is Greater Than 2147                   '/

C     Add error messages for HE > ZI issue.
      DATA ERRCOD(146)/'282'/,
c     & ERRMSG(146)/'Receptor < stack base could give anomalous results'/
c     & ERRMSG(146)/'Consider non-DFAULT HE>ZI opt for Rec Elev < Stack'/
c     & ERRMSG(146)/'Rec Elev < Stack Base: Consider non-DFAULT option '/
c     & ERRMSG(146)/'RecElev < SrcBase; Consider non-DFAULT HE>ZI opt.-'/
     & ERRMSG(146)/'RecElev < SrcBase; See non-DFAULT HE>ZI option in '/
      DATA ERRCOD(147)/'283'/,
     & ERRMSG(147)/'HE > ZI for the following source and receptor:    '/

      END MODULE MAIN1


      MODULE DEPVAR
c-----------------------------------------------------------------------
c --- ISCST2    Version: 1.0            Level: 931215        DEPVAR
c               D. Strimaitis, SRC
c
c PURPOSE:     Include-file of parameters and commons for deposition
c
c MODIFIED:    Split terrain grid common blocks to avoid alignment warning.
c              R. Brode, PES, Inc. - 5/24/95
c
c MODIFIED:    Added variable kurdat to common.
c              R. Brode, PES, Inc. - 9/30/94
c
c-----------------------------------------------------------------------
C     The following commented line provides the array limits for the
C     Microsoft executable file.

      IMPLICIT NONE

c-----------------------------------------------------------------------
c --- PARAMETERS
c-----------------------------------------------------------------------
      REAL, PARAMETER :: rtpiby2 = 1.2533141, rt2 = 1.4142136,
     &                   rtpi = 1.7724539

c-----------------------------------------------------------------------
c --- COMMON BLOCK /DEPVAR/ --- Source Depletion Variables
c-----------------------------------------------------------------------
      LOGICAL   :: rural, urban, lterr, debug, ltoxics
      CHARACTER :: srctyp*8
      REAL ::      vd, vs, zd, ap, bp, cp, ar, br, cr,
     &             hmix, onebyu,
     &             er, ep, xsrc, ysrc, xrec, yrec,
     &             xr, xv, h, sgz, sgz0, xtd, sztd, szmn
      INTEGER ::   igrav, kst, iounit, kurdat

c-----------------------------------------------------------------------
c --- COMMON BLOCK /TGRID/ --- Gridded Terrain Variables
c-----------------------------------------------------------------------
      LOGICAL ltgrid
      INTEGER (KIND=2), ALLOCATABLE :: izarray(:,:)
      REAL ::         xllm, yllm, sizem, xurm, yurm
      INTEGER ::      ntx, nty

c-----------------------------------------------------------------------
c     DEFINITIONS       [i]=integer     [r]=real       [l]=logical
c-----------------------------------------------------------------------
c                      - PARAMETERS -
c rtpiby2        square root of pi/2                                 [r]
c rt2            square root of 2                                    [r]
c rtpi           square root of pi                                   [r]
c (note: mxtx and mxty now allocated at runtime)
c
c                         /DEPVAR/
c vd (m/s)       deposition velocity                                 [r]
c vs (m/s)       gravitational settling velocity                     [r]
c zd (m)         reference height for deposition calculation         [r]
c ap,bp,cp       coefficients for analytical form of profile fcn     [r]
c ar,br,cr       coefficients for resistance function                [r]
c igrav          flag for treatment of gravitational settling        [i]
c                  0:use analytical approximation to profile integral
c                  1:use numerical solution to profile integral
c rural,urban    logical indicators for dispersion site character    [l]
c kst            P-G stability class                                 [i]
c hmix (m)       mixing height                                       [r]
c onebyu (s/m)   reciprocal of wind speed                            [r]
c er (m)         elevation (MSL) of receptor location                [r]
c ep (m)         elevation (MSL) of point-source location            [r]
c (x,y)src (m)   source location                                     [r]
c (x,y)rec (m)   receptor location                                   [r]
c xr (m)         distance from source to receptor                    [r]
c xv (m)         virtual source distance upwind of actual source     [r]
c h (m)          plume centerline height (no gravitational settling) [r]
c sgz (m)        sigma-z                                             [r]
c sgz0 (m)       initial sigma-z (e.g. for BID)                      [r]
c xtd (m)        distance to centerline "touchdown" (settling)       [r]
c sgtd (m)       sigma-z at xtd                                      [r]
c szmn (m)       minimum allowed for "settling" sigma-z              [r]
c lterr          logical controlling terrain adjustments             [l]
c debug          logical indicator for debug option                  [l]
c iounit         unit number for debug output                        [i]
c srctyp         source type (8 characters)                          [c]
c
c                         /TGRID/
c (x,y)llm   (m) coordinates of SW corner of cell1 (lower left
c                  corner) of terrain grid                           [r]
c sizem      (m) length of side of terrain grid cell                 [r]
c (x,y)urm   (m) coordinates of upper right corner of terrain grid   [r]
c izarray (m MSL) gridded terrain elevation data                     [i]
c
c  NOTE:  This grid contains terrain elevations at the corner of each
c         cell.  Therefore there are nx+1 points in x, and ny+1 points
c         in y.  The coordinates are assumed to be referenced to the
c         same origin used to specify source and receptor locations.
c-----------------------------------------------------------------------

      END MODULE DEPVAR
